package furny.ga;

import ga.view.interfaces.IPhenotypeGenerator;

import com.jme3.asset.AssetManager;
import com.jme3.scene.Node;

/**
 * This class is the decoder for furniture genotypes. It creates phenotypes.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public class FurnLayoutPhenotypeGenerator implements
    IPhenotypeGenerator<FurnLayoutIndividual, Node> {

  /**
   * Creates a new furniture phenotype generator.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public FurnLayoutPhenotypeGenerator() {
    super();

  }

  @Override
  public void setAssetManager(final AssetManager assetManager) {
    // not required in this case
  }

  @Override
  public Node createPhenotype(final FurnLayoutIndividual individual) {
    final Node n = new Node("Individual " + individual.getId() + " phenotype");

    for (final FurnEntry entry : individual.getFurnitures().clone()) {
      n.attachChild(entry.createTranslatedModel());
    }

    // GeometryBatchFactory.optimize(n);

    return n;
  }
}
